# Telegram Service Panel (WebView-ready) — PHP (No Framework)

This is a lightweight, production-minded PHP 8.1+ project designed for:
- Telegram services store / panel (WebView friendly UI)
- OTP login (Kavenegar driver placeholder + fallback demo)
- Roles: user/admin (admin routes protected)
- Services catalog, orders, wallet ledger
- Payment gateways scaffolding: Zibal + BitPay (request/verify/callback endpoints with TODO placeholders)
- Cron/CLI tasks

## Requirements
- PHP 8.1+
- ext-curl enabled
- (Recommended) ext-pdo_sqlite enabled (falls back to JSON storage if not)
- Web server rewrite enabled (Apache mod_rewrite) OR use query routing

## Install
1) Upload contents of this zip to your host.
2) Ensure these directories are writable:
   - `/data`
   - `/data/json` (if SQLite is missing)
   - `/logs`
3) Edit `/app/config.php`:
   - `app.base_path` (usually `/public` if hosted like https://domain/public/)
   - Kavenegar API key (optional)
   - Zibal / BitPay keys (optional)
4) Open:
   - `/public/login`

## Demo login
- OTP demo code: `1234` works if Kavenegar is not configured.
- To access admin: login with phone starting with `00` (e.g. `00123456789`) + `1234`.
  Then open `/public/admin`.

## Cron (CLI)
Run:
```bash
php cron/run.php task=cleanup-otp
php cron/run.php task=reconcile-payments
php cron/run.php task=advance-orders
```

## Notes
- Payment drivers contain TODO placeholders for signature verification and gateway-specific fields.
- This project is intentionally framework-free but structured (controllers/models/services/views).
