<?php

class Middleware
{
    public static function session(array $config): void
    {
        $sess = $config['session'] ?? [];
        session_name((string)($sess['name'] ?? 'sid'));

        session_set_cookie_params([
            'lifetime' => 0,
            'path' => '/',
            'secure' => (bool)($sess['cookie_secure'] ?? false),
            'httponly' => (bool)($sess['cookie_httponly'] ?? true),
            'samesite' => (string)($sess['cookie_samesite'] ?? 'Lax'),
        ]);

        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }

        $interval = (int)($sess['regenerate_interval_sec'] ?? 300);
        $last = (int)($_SESSION['_sid_regen'] ?? 0);
        if ($last === 0 || (time() - $last) > $interval) {
            session_regenerate_id(true);
            $_SESSION['_sid_regen'] = time();
        }
    }

    public static function csrf(array $config): void
    {
        $key = (string)($config['csrf']['key'] ?? '_csrf');
        csrf_verify($key);
    }
}
