<?php

class Service
{
    public static function seedIfEmpty(Db $db, ?JsonStore $js): void
    {
        if ($db->pdo()) {
            $pdo = $db->pdo();
            $count = (int)$pdo->query('SELECT COUNT(*) FROM categories')->fetchColumn();
            if ($count === 0) {
                $pdo->exec("INSERT INTO categories (title, description) VALUES
                    ('ممبر','افزایش اعضا در کانال و گروه'),
                    ('لایک','افزایش لایک پست‌ها'),
                    ('بازدید','ویو پست و استوری'),
                    ('کامنت','کامنت واقعی و قابل زمان‌بندی')
                ");
            }
            $sc = (int)$pdo->query('SELECT COUNT(*) FROM services')->fetchColumn();
            if ($sc === 0) {
                $pdo->exec("INSERT INTO services (category_id,title,description,min_qty,max_qty,unit_price,active) VALUES
                    (1,'ممبر ویژه کانال','سرعت مناسب و ریزش پایین',50,10000,9800,1),
                    (1,'ممبر تضمینی','تعهد بازگشت در صورت ریزش',100,20000,14500,1),
                    (2,'لایک سریع','تحویل لحظه‌ای با کیفیت بالا',50,5000,7200,1)
                ");
            }
            return;
        }

        // JSON
        $cats = $js->read('categories');
        if (!$cats) {
            $cats = [
                ['id'=>1,'title'=>'ممبر','description'=>'افزایش اعضا در کانال و گروه'],
                ['id'=>2,'title'=>'لایک','description'=>'افزایش لایک پست‌ها'],
                ['id'=>3,'title'=>'بازدید','description'=>'ویو پست و استوری'],
                ['id'=>4,'title'=>'کامنت','description'=>'کامنت واقعی و قابل زمان‌بندی'],
            ];
            $js->write('categories', $cats);
        }
        $sv = $js->read('services');
        if (!$sv) {
            $sv = [
                ['id'=>1,'category_id'=>1,'title'=>'ممبر ویژه کانال','description'=>'سرعت مناسب و ریزش پایین','min_qty'=>50,'max_qty'=>10000,'unit_price'=>9800,'active'=>1],
                ['id'=>2,'category_id'=>1,'title'=>'ممبر تضمینی','description'=>'تعهد بازگشت در صورت ریزش','min_qty'=>100,'max_qty'=>20000,'unit_price'=>14500,'active'=>1],
                ['id'=>3,'category_id'=>2,'title'=>'لایک سریع','description'=>'تحویل لحظه‌ای با کیفیت بالا','min_qty'=>50,'max_qty'=>5000,'unit_price'=>7200,'active'=>1],
            ];
            $js->write('services', $sv);
        }
    }
}
