<?php

class User
{
    public static function findOrCreateByPhone($db, ?JsonStore $js, string $phone, string $role = 'user'): array
    {
        if ($db instanceof Db && $db->pdo()) {
            $pdo = $db->pdo();
            $stmt = $pdo->prepare('SELECT * FROM users WHERE phone = ?');
            $stmt->execute([$phone]);
            $u = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($u) return $u;

            $ins = $pdo->prepare('INSERT INTO users (phone, role, created_at) VALUES (?, ?, ?)');
            $ins->execute([$phone, $role, now()]);
            $id = (int)$pdo->lastInsertId();
            return ['id'=>$id,'phone'=>$phone,'role'=>$role,'created_at'=>now()];
        }

        // JSON fallback
        $users = $js->read('users');
        foreach ($users as $u) {
            if (($u['phone'] ?? '') === $phone) return $u;
        }
        $id = $js->nextId($users);
        $u = ['id'=>$id,'phone'=>$phone,'role'=>$role,'created_at'=>now()];
        $users[] = $u;
        $js->write('users', $users);
        return $u;
    }
}
