<?php

class Router
{
    private array $routes = [];

    public function get(string $path, callable $handler): void { $this->map('GET', $path, $handler); }
    public function post(string $path, callable $handler): void { $this->map('POST', $path, $handler); }

    public function map(string $method, string $path, callable $handler): void {
        $method = strtoupper($method);
        $path = '/' . trim($path, '/');
        if ($path === '/') $path = '/';
        $this->routes[$method][$path] = $handler;
    }

    public function dispatch(string $method, string $path): void {
        $method = strtoupper($method);
        $path = '/' . ltrim($path, '/');
        if ($path !== '/') $path = rtrim($path, '/');

        $handler = $this->routes[$method][$path] ?? null;
        if (!$handler) {
            http_response_code(404);
            echo '404 Not Found';
            return;
        }
        $handler();
    }
}
