<?php

class KavenegarOtp
{
    private string $apiKey;
    private string $demoCode;
    private int $ttl;
    private int $rateLimitSeconds;

    public function __construct(array $config)
    {
        $k = $config['otp']['kavenegar']['api_key'] ?? '';
        $this->apiKey = (string)$k;
        $this->demoCode = (string)($config['otp']['demo_code'] ?? '1234');
        $this->ttl = (int)($config['otp']['otp_ttl_seconds'] ?? 300);
        $this->rateLimitSeconds = (int)($config['otp']['rate_limit_seconds'] ?? 60);
    }

    /**
     * Sends OTP. If apiKey missing, returns demo code and logs it.
     * Real Kavenegar integration: implement API call and handle response.
     */
    public function send(string $phone, string $code): bool
    {
        if ($this->apiKey === '' || str_contains($this->apiKey, 'PUT_YOUR')) {
            log_line("OTP DEMO for $phone => $code");
            return true;
        }

        // TODO: Implement real Kavenegar API call.
        // Example endpoints vary by method (VerifyLookup recommended).
        // Keep this as placeholder to avoid fake "success".
        log_line("Kavenegar not implemented yet. Refusing to fake success.");
        return false;
    }
}
