<?php

class BitPayGateway
{
    private string $apiKey;
    private string $callbackUrl;

    public function __construct(array $config)
    {
        $this->apiKey = (string)($config['payments']['bitpay']['api_key'] ?? '');
        $cbPath = (string)($config['payments']['bitpay']['callback_path'] ?? '/payment/bitpay/callback');
        $this->callbackUrl = $this->absoluteUrl($cbPath);
    }

    private function absoluteUrl(string $path): string
    {
        $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        return $scheme . '://' . $host . app_url($path);
    }

    public function isConfigured(): bool
    {
        return $this->apiKey !== '' && !str_contains($this->apiKey, 'PUT_YOUR');
    }

    public function request(int $amount, string $description, string $orderId): array
    {
        if (!$this->isConfigured()) {
            return ['ok'=>false,'error'=>'BitPay not configured'];
        }
        // TODO: Implement invoice creation with BitPay API.
        return ['ok'=>false,'error'=>'BitPay request not implemented'];
    }

    public function verify(string $invoiceId): array
    {
        if (!$this->isConfigured()) {
            return ['ok'=>false,'error'=>'BitPay not configured'];
        }
        // TODO: Implement invoice status check.
        return ['ok'=>false,'error'=>'BitPay verify not implemented'];
    }
}
