<?php

class ZibalGateway
{
    private string $merchant;
    private string $callbackUrl;

    public function __construct(array $config)
    {
        $this->merchant = (string)($config['payments']['zibal']['merchant'] ?? '');
        $cbPath = (string)($config['payments']['zibal']['callback_path'] ?? '/payment/zibal/callback');
        $this->callbackUrl = $this->absoluteUrl($cbPath);
    }

    private function absoluteUrl(string $path): string
    {
        $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
        return $scheme . '://' . $host . app_url($path);
    }

    public function isConfigured(): bool
    {
        return $this->merchant !== '' && !str_contains($this->merchant, 'PUT_YOUR');
    }

    /**
     * Create payment request.
     * Returns ['ok'=>bool,'authority'=>string,'pay_url'=>string,'raw'=>mixed]
     */
    public function request(int $amount, string $description, string $mobile, string $orderId): array
    {
        if (!$this->isConfigured()) {
            return ['ok'=>false,'error'=>'Zibal not configured'];
        }

        // TODO: Implement Zibal request API with cURL and proper payload.
        // Placeholder to avoid fake success:
        return ['ok'=>false,'error'=>'Zibal request not implemented'];
    }

    public function verify(string $authority): array
    {
        if (!$this->isConfigured()) {
            return ['ok'=>false,'error'=>'Zibal not configured'];
        }
        // TODO: Implement verify with Zibal API.
        return ['ok'=>false,'error'=>'Zibal verify not implemented'];
    }
}
