<?php

class Db
{
    private ?PDO $pdo = null;

    public function __construct(array $config)
    {
        $prefer = (bool)($config['storage']['prefer_sqlite'] ?? true);
        $path = (string)($config['storage']['sqlite_path'] ?? '');
        if ($prefer && extension_loaded('pdo_sqlite') && $path !== '') {
            ensure_dir(dirname($path));
            $this->pdo = new PDO('sqlite:' . $path);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->migrate();
        }
    }

    public function pdo(): ?PDO { return $this->pdo; }

    private function migrate(): void
    {
        if (!$this->pdo) return;

        $this->pdo->exec('CREATE TABLE IF NOT EXISTS users (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            phone TEXT UNIQUE,
            role TEXT DEFAULT "user",
            created_at TEXT
        )');

        $this->pdo->exec('CREATE TABLE IF NOT EXISTS otp_codes (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            phone TEXT,
            code TEXT,
            expires_at INTEGER,
            created_at INTEGER
        )');

        $this->pdo->exec('CREATE TABLE IF NOT EXISTS categories (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            title TEXT,
            description TEXT
        )');

        $this->pdo->exec('CREATE TABLE IF NOT EXISTS services (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            category_id INTEGER,
            title TEXT,
            description TEXT,
            min_qty INTEGER,
            max_qty INTEGER,
            unit_price INTEGER,
            active INTEGER DEFAULT 1
        )');

        $this->pdo->exec('CREATE TABLE IF NOT EXISTS orders (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            user_id INTEGER,
            service_id INTEGER,
            link TEXT,
            quantity INTEGER,
            status TEXT,
            total_price INTEGER,
            created_at TEXT
        )');

        $this->pdo->exec('CREATE TABLE IF NOT EXISTS wallet_ledger (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            user_id INTEGER,
            type TEXT,
            amount INTEGER,
            reference TEXT,
            meta TEXT,
            created_at TEXT
        )');

        $this->pdo->exec('CREATE TABLE IF NOT EXISTS payments (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            user_id INTEGER,
            gateway TEXT,
            amount INTEGER,
            status TEXT,
            authority TEXT,
            reference TEXT,
            meta TEXT,
            created_at TEXT
        )');
    }
}
