<?php

class JsonStore
{
    private string $dir;

    public function __construct(string $dir)
    {
        $this->dir = rtrim($dir, '/');
        ensure_dir($this->dir);
    }

    private function file(string $name): string {
        $safe = preg_replace('/[^a-zA-Z0-9_\-]/', '', $name);
        return $this->dir . '/' . $safe . '.json';
    }

    public function read(string $name): array {
        $f = $this->file($name);
        if (!is_file($f)) return [];
        $raw = file_get_contents($f);
        $data = is_string($raw) ? json_decode($raw, true) : null;
        return is_array($data) ? $data : [];
    }

    public function write(string $name, array $data): void {
        $f = $this->file($name);
        file_put_contents($f, json_encode($data, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT), LOCK_EX);
    }

    public function nextId(array $items): int {
        $max = 0;
        foreach ($items as $it) {
            $id = (int)($it['id'] ?? 0);
            if ($id > $max) $max = $id;
        }
        return $max + 1;
    }
}
