<?php $csrfKey = (string)($_config['csrf']['key'] ?? '_csrf'); ?>
<div class="card">
  <h2>پنل ادمین</h2>
  <div class="kpi">
    <div><div class="k"><?= number_format((int)($stats['users'] ?? 0)) ?></div><div class="muted">کاربران</div></div>
    <div><div class="k"><?= number_format((int)($stats['orders'] ?? 0)) ?></div><div class="muted">سفارشات</div></div>
    <div><div class="k"><?= number_format((int)($stats['revenue'] ?? 0)) ?></div><div class="muted">جمع سفارشات</div></div>
    <div><div class="k"><?= number_format((int)($stats['wallet'] ?? 0)) ?></div><div class="muted">جمع کیف پول</div></div>
  </div>
</div>

<div class="card">
  <h3>آخرین سفارشات</h3>
  <?php if (!$orders): ?>
    <p class="muted">سفارشی وجود ندارد.</p>
  <?php else: ?>
    <div class="list">
      <?php foreach ($orders as $o): ?>
        <div class="row">
          <div>
            <div class="title"><?= h($o['phone'] ?? '') ?> — <?= h($o['service_title'] ?? '') ?></div>
            <div class="muted">تعداد: <?= (int)($o['quantity'] ?? 0) ?> · مبلغ: <?= number_format((int)($o['total_price'] ?? 0)) ?> · وضعیت: <b><?= h($o['status'] ?? '') ?></b></div>
          </div>
          <div class="right">
            <form method="post" action="<?= h(app_url('/admin/order-status')) ?>" class="inline">
              <?= csrf_field($csrfKey) ?>
              <input type="hidden" name="id" value="<?= (int)($o['id'] ?? 0) ?>">
              <select name="status">
                <?php foreach (['pending','processing','completed','canceled'] as $st): ?>
                  <option value="<?= h($st) ?>" <?= ($st===($o['status']??''))?'selected':'' ?>><?= h($st) ?></option>
                <?php endforeach; ?>
              </select>
              <button type="submit">ثبت</button>
            </form>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>
