<?php $csrfKey = (string)($_config['csrf']['key'] ?? '_csrf'); ?>
<div class="grid2">
  <div class="card">
    <h2>افزودن سرویس</h2>
    <form method="post" action="<?= h(app_url('/admin/service-create')) ?>" class="rowform">
      <?= csrf_field($csrfKey) ?>
      <label class="field">عنوان<input name="title" required></label>
      <label class="field">توضیحات<input name="description" required></label>
      <label class="field">دسته‌بندی
        <select name="category_id" required>
          <?php foreach ($categories as $c): ?>
            <option value="<?= (int)($c['id'] ?? 0) ?>"><?= h($c['title'] ?? '') ?></option>
          <?php endforeach; ?>
        </select>
      </label>
      <label class="field">حداقل<input type="number" name="min_qty" required></label>
      <label class="field">حداکثر<input type="number" name="max_qty" required></label>
      <label class="field">قیمت واحد<input type="number" name="unit_price" required></label>
      <label class="check"><input type="checkbox" name="active" checked> فعال</label>
      <button type="submit">ثبت</button>
    </form>
  </div>

  <div class="card">
    <h2>لیست سرویس‌ها</h2>
    <div class="list">
      <?php foreach ($services as $s): ?>
        <div class="row">
          <div>
            <div class="title"><?= h($s['title'] ?? '') ?></div>
            <div class="muted"><?= h($s['description'] ?? '') ?></div>
            <div class="muted">Min <?= (int)($s['min_qty'] ?? 0) ?> · Max <?= (int)($s['max_qty'] ?? 0) ?> · Unit <?= number_format((int)($s['unit_price'] ?? 0)) ?></div>
          </div>
          <div class="right">
            <form method="post" action="<?= h(app_url('/admin/service-toggle')) ?>" class="inline">
              <?= csrf_field($csrfKey) ?>
              <input type="hidden" name="id" value="<?= (int)($s['id'] ?? 0) ?>">
              <button type="submit"><?= ((int)($s['active'] ?? 0)===1) ? 'غیرفعال' : 'فعال' ?></button>
            </form>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>
