<?php
/** @var array $_config */
/** @var string $_template */
/** @var ?string $_flash */
$title = $title ?? ($_config['app']['name'] ?? 'App');
$user = current_user();
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <title><?= h($title) ?></title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?= h(app_url('/assets/css/app.css')) ?>">
</head>
<body>
  <div class="shell">
    <header class="top">
      <div class="brand">
        <div class="logo">✈️</div>
        <div>
          <div class="name"><?= h($_config['app']['name'] ?? 'تلگرام سرویس') ?></div>
          <div class="sub">WebView Panel</div>
        </div>
      </div>
      <?php if ($user): ?>
        <div class="userchip">
          <span><?= h($user['phone'] ?? '') ?></span>
          <span class="pill"><?= h($user['role'] ?? 'user') ?></span>
        </div>
      <?php endif; ?>
    </header>

    <?php if ($user): ?>
      <nav class="nav">
        <a href="<?= h(app_url('/dashboard')) ?>">🏠 داشبورد</a>
        <a href="<?= h(app_url('/services')) ?>">🧩 سرویس‌ها</a>
        <a href="<?= h(app_url('/orders')) ?>">🧾 سفارشات</a>
        <a href="<?= h(app_url('/wallet')) ?>">💳 کیف پول</a>
        <?php if (is_admin()): ?>
          <a href="<?= h(app_url('/admin')) ?>">🛡️ ادمین</a>
          <a href="<?= h(app_url('/admin/services')) ?>">⚙️ سرویس‌ها</a>
        <?php endif; ?>
        <a class="danger" href="<?= h(app_url('/logout')) ?>">🚪 خروج</a>
      </nav>
    <?php endif; ?>

    <?php if ($_flash): ?>
      <div class="flash"><?= h($_flash) ?></div>
    <?php endif; ?>

    <main class="main">
      <?php require dirname(__DIR__) . '/Views/' . $_template . '.php'; ?>
    </main>

    <footer class="footer">
      <span>© <?= date('Y') ?> <?= h($_config['app']['name'] ?? '') ?></span>
      <span class="muted">v1.0</span>
    </footer>
  </div>

  <script src="<?= h(app_url('/assets/js/app.js')) ?>"></script>
</body>
</html>
