<?php $csrfKey = (string)($_config['csrf']['key'] ?? '_csrf'); ?>
<div class="card">
  <?php if (!$service): ?>
    <h3>سرویس پیدا نشد</h3>
  <?php else: ?>
    <h2><?= h($service['title'] ?? '') ?></h2>
    <p class="muted"><?= h($service['description'] ?? '') ?></p>
    <div class="muted">حداقل <?= (int)($service['min_qty'] ?? 0) ?> · حداکثر <?= (int)($service['max_qty'] ?? 0) ?></div>
    <div class="muted">قیمت واحد: <?= number_format((int)($service['unit_price'] ?? 0)) ?> تومان</div>

    <form method="post" action="<?= h(app_url('/order')) ?>" class="rowform" style="margin-top:12px;">
      <?= csrf_field($csrfKey) ?>
      <input type="hidden" name="service_id" value="<?= (int)($service['id'] ?? 0) ?>">
      <label class="field">
        لینک
        <input name="link" placeholder="https://t.me/..." required>
      </label>
      <label class="field">
        تعداد
        <input name="quantity" type="number" min="<?= (int)($service['min_qty'] ?? 0) ?>" max="<?= (int)($service['max_qty'] ?? 0) ?>" required>
      </label>
      <label class="check">
        <input type="checkbox" name="use_wallet" value="1" />
        پرداخت از کیف پول (در صورت کافی بودن موجودی)
      </label>
      <button type="submit">ثبت سفارش</button>
    </form>
  <?php endif; ?>
</div>
