<?php $csrfKey = (string)($_config['csrf']['key'] ?? '_csrf'); ?>
<div class="grid2">
  <div class="card">
    <h2>کیف پول</h2>
    <div class="kpi">
      <div>
        <div class="k"><?= number_format((int)$wallet) ?></div>
        <div class="muted">موجودی (تومان)</div>
      </div>
    </div>

    <h3 style="margin-top:14px;">شارژ</h3>
    <form method="post" action="<?= h(app_url('/payment/start')) ?>" class="rowform">
      <?= csrf_field($csrfKey) ?>
      <label class="field">
        مبلغ (تومان)
        <input type="number" name="amount" min="1000" required>
      </label>
      <label class="field">
        درگاه
        <select name="gateway" required>
          <option value="zibal">Zibal</option>
          <option value="bitpay">BitPay</option>
        </select>
      </label>
      <button type="submit">شروع پرداخت</button>
    </form>

    <div class="note">
      این نسخه اسکلت حرفه‌ای درگاه‌هاست. تا وقتی کلیدهای درگاه را در <code>app/config.php</code> نگذاری و متدهای request/verify را تکمیل نکنی، پرداخت واقعی انجام نمی‌شود.
    </div>
  </div>

  <div class="card">
    <h2>گردش حساب</h2>
    <?php if (!$ledger): ?>
      <p class="muted">تراکنشی ندارید.</p>
    <?php else: ?>
      <div class="list">
        <?php foreach ($ledger as $l): ?>
          <div class="row">
            <div>
              <div class="title"><?= h($l['reference'] ?? '') ?></div>
              <div class="muted"><?= h($l['type'] ?? '') ?> · <?= h($l['created_at'] ?? '') ?></div>
            </div>
            <div class="right">
              <div class="price"><?= number_format((int)($l['amount'] ?? 0)) ?></div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>
