<?php
return [
    'app' => [
        'name' => 'تلگرام سرویس',
        // If your app is served at https://domain/public/... keep '/public'
        // If served at https://domain/... set ''.
        'base_path' => '/public',
        'debug' => true,
        'timezone' => 'Asia/Tehran',
    ],

    'session' => [
        'name' => 'tsid',
        'cookie_secure' => false, // set true if HTTPS
        'cookie_httponly' => true,
        'cookie_samesite' => 'Lax', // good for WebView
        'regenerate_interval_sec' => 300,
    ],

    'csrf' => [
        'key' => '_csrf',
    ],

    'storage' => [
        'prefer_sqlite' => true,
        'sqlite_path' => dirname(__DIR__) . '/data/app.sqlite',
        'json_dir' => dirname(__DIR__) . '/data/json',
    ],

    'otp' => [
        'provider' => 'kavenegar', // kavenegar|demo
        'demo_code' => '1234',
        'rate_limit_seconds' => 60,
        'otp_ttl_seconds' => 300,
        'kavenegar' => [
            'api_key' => 'PUT_YOUR_KAVENEGAR_API_KEY',
            'sender' => '', // optional
            'template' => '', // optional
        ],
    ],

    'payments' => [
        'zibal' => [
            'merchant' => 'PUT_YOUR_ZIBAL_MERCHANT',
            'callback_path' => '/payment/zibal/callback',
        ],
        'bitpay' => [
            'api_key' => 'PUT_YOUR_BITPAY_API_KEY',
            'callback_path' => '/payment/bitpay/callback',
        ],
    ],

    'security' => [
        // Change in production
        'admin_phone_prefix' => '00',
    ],
];
