<?php
declare(strict_types=1);

$CONFIG = require dirname(__DIR__) . '/app/config.php';
$GLOBALS['APP_CONFIG'] = $CONFIG;

require dirname(__DIR__) . '/app/helpers.php';
require dirname(__DIR__) . '/app/Router.php';
require dirname(__DIR__) . '/app/View.php';
require dirname(__DIR__) . '/app/Middleware.php';
require dirname(__DIR__) . '/app/Storage/Db.php';
require dirname(__DIR__) . '/app/Storage/JsonStore.php';
require dirname(__DIR__) . '/app/Models/User.php';
require dirname(__DIR__) . '/app/Models/Service.php';
require dirname(__DIR__) . '/app/Models/Order.php';
require dirname(__DIR__) . '/app/Services/Otp/KavenegarOtp.php';
require dirname(__DIR__) . '/app/Services/Payments/ZibalGateway.php';
require dirname(__DIR__) . '/app/Services/Payments/BitPayGateway.php';
require dirname(__DIR__) . '/app/Controllers/AuthController.php';
require dirname(__DIR__) . '/app/Controllers/UserController.php';
require dirname(__DIR__) . '/app/Controllers/AdminController.php';

date_default_timezone_set((string)($CONFIG['app']['timezone'] ?? 'Asia/Tehran'));
error_reporting(E_ALL);
ini_set('display_errors', !empty($CONFIG['app']['debug']) ? '1' : '0');

Middleware::session($CONFIG);

$db = new Db($CONFIG);
$js = null;
if (!$db->pdo()) {
    $dir = (string)($CONFIG['storage']['json_dir'] ?? dirname(__DIR__).'/data/json');
    $js = new JsonStore($dir);
}

Service::seedIfEmpty($db, $js);

$router = new Router();

$auth = new AuthController($db, $js, $CONFIG);
$user = new UserController($db, $js, $CONFIG);
$admin = new AdminController($db, $js, $CONFIG);

// Auth
$router->get('/login', fn() => $auth->showLogin());
$router->post('/otp/send', fn() => $auth->sendOtp());
$router->post('/login', fn() => $auth->verifyLogin());
$router->get('/logout', fn() => $auth->logout());

// User
$router->get('/', fn() => redirect(app_url('/dashboard')));
$router->get('/dashboard', fn() => $user->dashboard());
$router->get('/services', fn() => $user->services());
$router->get('/service', fn() => $user->service());
$router->post('/order', fn() => $user->createOrder());
$router->get('/orders', fn() => $user->orders());
$router->get('/wallet', fn() => $user->wallet());
$router->post('/payment/start', fn() => $user->startPayment());
$router->get('/payment/zibal/callback', fn() => $user->paymentZibalCallback());
$router->get('/payment/bitpay/callback', fn() => $user->paymentBitpayCallback());

// Admin
$router->get('/admin', fn() => $admin->dashboard());
$router->get('/admin/services', fn() => $admin->services());
$router->post('/admin/service-create', fn() => $admin->serviceCreate());
$router->post('/admin/service-toggle', fn() => $admin->serviceToggle());
$router->post('/admin/order-status', fn() => $admin->orderStatus());

// Routing mode: rewrite OR query ?path=
$path = request_uri_path();
$base = rtrim((string)($CONFIG['app']['base_path'] ?? ''), '/');
if ($base !== '' && str_starts_with($path, $base)) {
    $path = substr($path, strlen($base));
    $path = $path === '' ? '/' : $path;
}
if (isset($_GET['path']) && is_string($_GET['path']) && $_GET['path'] !== '') {
    $path = '/' . ltrim($_GET['path'], '/');
}

Middleware::csrf($CONFIG);

$router->dispatch(request_method(), $path);
